<?php

namespace App\Http\Livewire;

use App\Models\Member;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\TableComponent;
use Rappasoft\LaravelLivewireTables\Traits\HtmlComponents;
use Rappasoft\LaravelLivewireTables\Views\Column;

class MembersTable extends TableComponent
{
    use HtmlComponents;

    public function query(): Builder
    {
        return Member::with('group');
    }

    public function columns(): array
    {
        return [
            Column::make('ID')
                ->searchable()
                ->sortable(),
            Column::make('KBII', 'group.code')
                ->searchable()
                ->sortable(),
            Column::make('Halaqah Tanfidz', 'group.name')
                ->searchable()
                ->sortable(),
            Column::make('Murobbi', 'group.murobbi')
                ->searchable()
                ->sortable(),
            Column::make('Nama Peserta', 'name')
                ->searchable()
                ->sortable(),
        ];
    }
}
