<?php

namespace App\Http\Livewire;

use App\Models\Group;
use App\Models\Member;
use Livewire\Component;

class Stats extends Component
{
    public function render()
    {
        $code_count = Group::distinct()->count('code');
        $group_count = Group::count();
        $member_count = Member::count();
        return view('livewire.stats', compact('code_count', 'group_count', 'member_count'));
    }
}