<?php

namespace App\Models;

use \DateTimeInterface;
use App\Traits\MultiTenantModelTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Site extends Model
{
    use SoftDeletes;
    use MultiTenantModelTrait;
    use HasFactory;

    public $table = 'sites';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'code',
        'name',
        'lat',
        'long',
        'created_at',
        'updated_at',
        'deleted_at',
        'team_id',
    ];

    public function sourceSiteProjects()
    {
        return $this->hasMany(Project::class, 'source_site_id', 'id');
    }

    public function destinationSiteProjects()
    {
        return $this->hasMany(Project::class, 'destination_site_id', 'id');
    }

    public function siteDevices()
    {
        return $this->hasMany(Device::class, 'site_id', 'id');
    }

    public function team()
    {
        return $this->belongsTo(Team::class, 'team_id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
