<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToProjectsTable extends Migration
{
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->unsignedBigInteger('source_site_id')->nullable();
            $table->foreign('source_site_id', 'source_site_fk_7501240')->references('id')->on('sites');
            $table->unsignedBigInteger('destination_site_id')->nullable();
            $table->foreign('destination_site_id', 'destination_site_fk_7501241')->references('id')->on('sites');
            $table->unsignedBigInteger('team_id')->nullable();
            $table->foreign('team_id', 'team_fk_7495424')->references('id')->on('teams');
        });
    }
}
