@can('inspection_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.inspections.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.inspection.title_singular') }}
            </a>
        </div>
    </div>
@endcan

<div class="card">
    <div class="card-header">
        {{ trans('cruds.inspection.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-assetInspections">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.inspection.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.inspection.fields.asset') }}
                        </th>
                        <th>
                            {{ trans('cruds.inspection.fields.user') }}
                        </th>
                        <th>
                            {{ trans('cruds.inspection.fields.datetime') }}
                        </th>
                        <th>
                            {{ trans('cruds.inspection.fields.photos') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($inspections as $key => $inspection)
                        <tr data-entry-id="{{ $inspection->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $inspection->id ?? '' }}
                            </td>
                            <td>
                                {{ $inspection->asset->code ?? '' }}
                            </td>
                            <td>
                                {{ $inspection->user->name ?? '' }}
                            </td>
                            <td>
                                {{ $inspection->datetime ?? '' }}
                            </td>
                            <td>
                                @foreach($inspection->photos as $key => $media)
                                    <a href="{{ $media->getUrl() }}" target="_blank" style="display: inline-block">
                                        <img src="{{ $media->getUrl('thumb') }}">
                                    </a>
                                @endforeach
                            </td>
                            <td>
                                @can('inspection_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.inspections.show', $inspection->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('inspection_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.inspections.edit', $inspection->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('inspection_delete')
                                    <form action="{{ route('admin.inspections.destroy', $inspection->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('inspection_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.inspections.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-assetInspections:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection