@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.officer.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.officers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.officer.fields.id') }}
                        </th>
                        <td>
                            {{ $officer->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.officer.fields.name') }}
                        </th>
                        <td>
                            {{ $officer->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.officer.fields.photo') }}
                        </th>
                        <td>
                            @if($officer->photo)
                                <a href="{{ $officer->photo->getUrl() }}" target="_blank" style="display: inline-block">
                                    <img src="{{ $officer->photo->getUrl('thumb') }}">
                                </a>
                            @endif
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.officers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#assigned_to_tasks" role="tab" data-toggle="tab">
                {{ trans('cruds.task.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="assigned_to_tasks">
            @includeIf('admin.officers.relationships.assignedToTasks', ['tasks' => $officer->assignedToTasks])
        </div>
    </div>
</div>

@endsection