@can('outbox_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.outboxes.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.outbox.title_singular') }}
            </a>
        </div>
    </div>
@endcan

<div class="card">
    <div class="card-header">
        {{ trans('cruds.outbox.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-receiverOutboxes">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.category') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.letterhead') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.number') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.date') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.sender') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.receiver') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.regarding') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.filename') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.signers') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.deadline') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.file') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.photo') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.owner') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.assigned_to') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.shared_to') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.shared_link') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.tags') }}
                        </th>
                        <th>
                            {{ trans('cruds.outbox.fields.status') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($outboxes as $key => $outbox)
                        <tr data-entry-id="{{ $outbox->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $outbox->id ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->category->name ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->letterhead->name ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->number ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->date ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->sender->name ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->receiver->name ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->regarding ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->filename ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->signers ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->deadline ?? '' }}
                            </td>
                            <td>
                                @foreach($outbox->file as $key => $media)
                                    <a href="{{ $media->getUrl() }}" target="_blank">
                                        {{ trans('global.view_file') }}
                                    </a>
                                @endforeach
                            </td>
                            <td>
                                @foreach($outbox->photo as $key => $media)
                                    <a href="{{ $media->getUrl() }}" target="_blank" style="display: inline-block">
                                        <img src="{{ $media->getUrl('thumb') }}">
                                    </a>
                                @endforeach
                            </td>
                            <td>
                                {{ $outbox->owner->name ?? '' }}
                            </td>
                            <td>
                                {{ $outbox->assigned_to->name ?? '' }}
                            </td>
                            <td>
                                @foreach($outbox->shared_tos as $key => $item)
                                    <span class="badge badge-info">{{ $item->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                {{ $outbox->shared_link ?? '' }}
                            </td>
                            <td>
                                @foreach($outbox->tags as $key => $item)
                                    <span class="badge badge-info">{{ $item->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                {{ App\Models\Outbox::STATUS_RADIO[$outbox->status] ?? '' }}
                            </td>
                            <td>
                                @can('outbox_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.outboxes.show', $outbox->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('outbox_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.outboxes.edit', $outbox->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('outbox_delete')
                                    <form action="{{ route('admin.outboxes.destroy', $outbox->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('outbox_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.outboxes.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-receiverOutboxes:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection