@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.village.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.villages.update", [$village->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="name">{{ trans('cruds.village.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', $village->name) }}" required>
                @if($errors->has('name'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.village.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="village_id">{{ trans('cruds.village.fields.village') }}</label>
                <select class="form-control select2 {{ $errors->has('village') ? 'is-invalid' : '' }}" name="village_id" id="village_id">
                    @foreach($villages as $id => $entry)
                        <option value="{{ $id }}" {{ (old('village_id') ? old('village_id') : $village->village->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('village'))
                    <div class="invalid-feedback">
                        {{ $errors->first('village') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.village.fields.village_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection