<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyTowerRequest;
use App\Http\Requests\StoreTowerRequest;
use App\Http\Requests\UpdateTowerRequest;
use App\Models\Tower;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class TowerController extends Controller
{
    public function index(Request $request)
    {
        abort_if(Gate::denies('tower_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Tower::query()->select(sprintf('%s.*', (new Tower())->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate = 'tower_show';
                $editGate = 'tower_edit';
                $deleteGate = 'tower_delete';
                $crudRoutePart = 'towers';

                return view('partials.datatablesActions', compact(
                'viewGate',
                'editGate',
                'deleteGate',
                'crudRoutePart',
                'row'
            ));
            });

            $table->editColumn('id', function ($row) {
                return $row->id ? $row->id : '';
            });
            $table->editColumn('name', function ($row) {
                return $row->name ? $row->name : '';
            });
            $table->editColumn('lat', function ($row) {
                return $row->lat ? $row->lat : '';
            });
            $table->editColumn('long', function ($row) {
                return $row->long ? $row->long : '';
            });
            $table->editColumn('status', function ($row) {
                return $row->status ? $row->status : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        return view('admin.towers.index');
    }

    public function create()
    {
        abort_if(Gate::denies('tower_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.towers.create');
    }

    public function store(StoreTowerRequest $request)
    {
        $tower = Tower::create($request->all());

        return redirect()->route('admin.towers.index');
    }

    public function edit(Tower $tower)
    {
        abort_if(Gate::denies('tower_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.towers.edit', compact('tower'));
    }

    public function update(UpdateTowerRequest $request, Tower $tower)
    {
        $tower->update($request->all());

        return redirect()->route('admin.towers.index');
    }

    public function show(Tower $tower)
    {
        abort_if(Gate::denies('tower_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $tower->load('towerSpaceUnits');

        return view('admin.towers.show', compact('tower'));
    }

    public function destroy(Tower $tower)
    {
        abort_if(Gate::denies('tower_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $tower->delete();

        return back();
    }

    public function massDestroy(MassDestroyTowerRequest $request)
    {
        Tower::whereIn('id', request('ids'))->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
