<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreSpaceUnitRequest;
use App\Http\Requests\UpdateSpaceUnitRequest;
use App\Http\Resources\Admin\SpaceUnitResource;
use App\Models\SpaceUnit;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SpaceUnitApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('space_unit_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new SpaceUnitResource(SpaceUnit::with(['tower'])->get());
    }

    public function store(StoreSpaceUnitRequest $request)
    {
        $spaceUnit = SpaceUnit::create($request->all());

        return (new SpaceUnitResource($spaceUnit))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(SpaceUnit $spaceUnit)
    {
        abort_if(Gate::denies('space_unit_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new SpaceUnitResource($spaceUnit->load(['tower']));
    }

    public function update(UpdateSpaceUnitRequest $request, SpaceUnit $spaceUnit)
    {
        $spaceUnit->update($request->all());

        return (new SpaceUnitResource($spaceUnit))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(SpaceUnit $spaceUnit)
    {
        abort_if(Gate::denies('space_unit_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $spaceUnit->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
