<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreTowerRequest;
use App\Http\Requests\UpdateTowerRequest;
use App\Http\Resources\Admin\TowerResource;
use App\Models\Tower;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TowerApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('tower_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new TowerResource(Tower::all());
    }

    public function store(StoreTowerRequest $request)
    {
        $tower = Tower::create($request->all());

        return (new TowerResource($tower))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Tower $tower)
    {
        abort_if(Gate::denies('tower_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new TowerResource($tower);
    }

    public function update(UpdateTowerRequest $request, Tower $tower)
    {
        $tower->update($request->all());

        return (new TowerResource($tower))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Tower $tower)
    {
        abort_if(Gate::denies('tower_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $tower->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
