<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroySpaceUnitRequest;
use App\Http\Requests\StoreSpaceUnitRequest;
use App\Http\Requests\UpdateSpaceUnitRequest;
use App\Models\SpaceUnit;
use App\Models\Tower;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SpaceUnitController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('space_unit_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $spaceUnits = SpaceUnit::with(['tower'])->get();

        return view('frontend.spaceUnits.index', compact('spaceUnits'));
    }

    public function create()
    {
        abort_if(Gate::denies('space_unit_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $towers = Tower::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('frontend.spaceUnits.create', compact('towers'));
    }

    public function store(StoreSpaceUnitRequest $request)
    {
        $spaceUnit = SpaceUnit::create($request->all());

        return redirect()->route('frontend.space-units.index');
    }

    public function edit(SpaceUnit $spaceUnit)
    {
        abort_if(Gate::denies('space_unit_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $towers = Tower::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $spaceUnit->load('tower');

        return view('frontend.spaceUnits.edit', compact('spaceUnit', 'towers'));
    }

    public function update(UpdateSpaceUnitRequest $request, SpaceUnit $spaceUnit)
    {
        $spaceUnit->update($request->all());

        return redirect()->route('frontend.space-units.index');
    }

    public function show(SpaceUnit $spaceUnit)
    {
        abort_if(Gate::denies('space_unit_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $spaceUnit->load('tower');

        return view('frontend.spaceUnits.show', compact('spaceUnit'));
    }

    public function destroy(SpaceUnit $spaceUnit)
    {
        abort_if(Gate::denies('space_unit_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $spaceUnit->delete();

        return back();
    }

    public function massDestroy(MassDestroySpaceUnitRequest $request)
    {
        SpaceUnit::whereIn('id', request('ids'))->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
