<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyTowerRequest;
use App\Http\Requests\StoreTowerRequest;
use App\Http\Requests\UpdateTowerRequest;
use App\Models\Tower;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TowerController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('tower_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $towers = Tower::all();

        return view('frontend.towers.index', compact('towers'));
    }

    public function create()
    {
        abort_if(Gate::denies('tower_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.towers.create');
    }

    public function store(StoreTowerRequest $request)
    {
        $tower = Tower::create($request->all());

        return redirect()->route('frontend.towers.index');
    }

    public function edit(Tower $tower)
    {
        abort_if(Gate::denies('tower_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.towers.edit', compact('tower'));
    }

    public function update(UpdateTowerRequest $request, Tower $tower)
    {
        $tower->update($request->all());

        return redirect()->route('frontend.towers.index');
    }

    public function show(Tower $tower)
    {
        abort_if(Gate::denies('tower_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('frontend.towers.show', compact('tower'));
    }

    public function destroy(Tower $tower)
    {
        abort_if(Gate::denies('tower_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $tower->delete();

        return back();
    }

    public function massDestroy(MassDestroyTowerRequest $request)
    {
        Tower::whereIn('id', request('ids'))->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
