<?php

namespace App\Http\Requests;

use App\Models\SpaceUnit;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroySpaceUnitRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('space_unit_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:space_units,id',
        ];
    }
}
