<?php

namespace App\Http\Requests;

use App\Models\Tower;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyTowerRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('tower_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:towers,id',
        ];
    }
}
