<?php

namespace App\Http\Requests;

use App\Models\SpaceUnit;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreSpaceUnitRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('space_unit_create');
    }

    public function rules()
    {
        return [
            'tower_id' => [
                'required',
                'integer',
            ],
            'type' => [
                'required',
            ],
            'status' => [
                'required',
            ],
            'sensor' => [
                'nullable',
                'integer',
                'min:-2147483648',
                'max:2147483647',
            ],
            'lat' => [
                'string',
                'nullable',
            ],
            'long' => [
                'string',
                'nullable',
            ],
        ];
    }
}
