<?php

namespace App\Models;

use \DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SpaceUnit extends Model
{
    use SoftDeletes;
    use HasFactory;

    public const STATUS_RADIO = [
        'free'     => 'Kosong',
        'occupied' => 'Isi',
    ];

    public const TYPE_RADIO = [
        'A' => 'Space Unit A',
        'B' => 'Space Unit B',
        'C' => 'Space Unit C',
        'D' => 'Space Unit D',
        'E' => 'Space Unit E',
    ];

    public $table = 'space_units';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'tower_id',
        'type',
        'status',
        'sensor',
        'lat',
        'long',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function tower()
    {
        return $this->belongsTo(Tower::class, 'tower_id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
