<?php

namespace App\Models;

use \DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tower extends Model
{
    use SoftDeletes;
    use HasFactory;

    public $table = 'towers';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'lat',
        'long',
        'status',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function towerSpaceUnits()
    {
        return $this->hasMany(SpaceUnit::class, 'tower_id', 'id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
