@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.spaceUnit.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.space-units.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.id') }}
                        </th>
                        <td>
                            {{ $spaceUnit->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.tower') }}
                        </th>
                        <td>
                            {{ $spaceUnit->tower->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.type') }}
                        </th>
                        <td>
                            {{ App\Models\SpaceUnit::TYPE_RADIO[$spaceUnit->type] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.status') }}
                        </th>
                        <td>
                            {{ App\Models\SpaceUnit::STATUS_RADIO[$spaceUnit->status] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.sensor') }}
                        </th>
                        <td>
                            {{ $spaceUnit->sensor }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.lat') }}
                        </th>
                        <td>
                            {{ $spaceUnit->lat }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.long') }}
                        </th>
                        <td>
                            {{ $spaceUnit->long }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.space-units.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection