@can('space_unit_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.space-units.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.spaceUnit.title_singular') }}
            </a>
        </div>
    </div>
@endcan

<div class="card">
    <div class="card-header">
        {{ trans('cruds.spaceUnit.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-towerSpaceUnits">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.tower') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.type') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.status') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.sensor') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.lat') }}
                        </th>
                        <th>
                            {{ trans('cruds.spaceUnit.fields.long') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($spaceUnits as $key => $spaceUnit)
                        <tr data-entry-id="{{ $spaceUnit->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $spaceUnit->id ?? '' }}
                            </td>
                            <td>
                                {{ $spaceUnit->tower->name ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\SpaceUnit::TYPE_RADIO[$spaceUnit->type] ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\SpaceUnit::STATUS_RADIO[$spaceUnit->status] ?? '' }}
                            </td>
                            <td>
                                {{ $spaceUnit->sensor ?? '' }}
                            </td>
                            <td>
                                {{ $spaceUnit->lat ?? '' }}
                            </td>
                            <td>
                                {{ $spaceUnit->long ?? '' }}
                            </td>
                            <td>
                                @can('space_unit_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.space-units.show', $spaceUnit->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('space_unit_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.space-units.edit', $spaceUnit->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('space_unit_delete')
                                    <form action="{{ route('admin.space-units.destroy', $spaceUnit->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('space_unit_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.space-units.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-towerSpaceUnits:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection