@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.tower.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.towers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.tower.fields.id') }}
                        </th>
                        <td>
                            {{ $tower->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.tower.fields.name') }}
                        </th>
                        <td>
                            {{ $tower->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.tower.fields.lat') }}
                        </th>
                        <td>
                            {{ $tower->lat }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.tower.fields.long') }}
                        </th>
                        <td>
                            {{ $tower->long }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.tower.fields.status') }}
                        </th>
                        <td>
                            {{ $tower->status }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.towers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#tower_space_units" role="tab" data-toggle="tab">
                {{ trans('cruds.spaceUnit.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="tower_space_units">
            @includeIf('admin.towers.relationships.towerSpaceUnits', ['spaceUnits' => $tower->towerSpaceUnits])
        </div>
    </div>
</div>

@endsection