@extends('layouts.frontend')
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card">
                <div class="card-header">
                    {{ trans('global.create') }} {{ trans('cruds.spaceUnit.title_singular') }}
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route("frontend.space-units.store") }}" enctype="multipart/form-data">
                        @method('POST')
                        @csrf
                        <div class="form-group">
                            <label class="required" for="tower_id">{{ trans('cruds.spaceUnit.fields.tower') }}</label>
                            <select class="form-control select2" name="tower_id" id="tower_id" required>
                                @foreach($towers as $id => $entry)
                                    <option value="{{ $id }}" {{ old('tower_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                                @endforeach
                            </select>
                            @if($errors->has('tower'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('tower') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.tower_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label class="required">{{ trans('cruds.spaceUnit.fields.type') }}</label>
                            @foreach(App\Models\SpaceUnit::TYPE_RADIO as $key => $label)
                                <div>
                                    <input type="radio" id="type_{{ $key }}" name="type" value="{{ $key }}" {{ old('type', 'A') === (string) $key ? 'checked' : '' }} required>
                                    <label for="type_{{ $key }}">{{ $label }}</label>
                                </div>
                            @endforeach
                            @if($errors->has('type'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('type') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.type_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label class="required">{{ trans('cruds.spaceUnit.fields.status') }}</label>
                            @foreach(App\Models\SpaceUnit::STATUS_RADIO as $key => $label)
                                <div>
                                    <input type="radio" id="status_{{ $key }}" name="status" value="{{ $key }}" {{ old('status', 'free') === (string) $key ? 'checked' : '' }} required>
                                    <label for="status_{{ $key }}">{{ $label }}</label>
                                </div>
                            @endforeach
                            @if($errors->has('status'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('status') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.status_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="sensor">{{ trans('cruds.spaceUnit.fields.sensor') }}</label>
                            <input class="form-control" type="number" name="sensor" id="sensor" value="{{ old('sensor', '0') }}" step="1">
                            @if($errors->has('sensor'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('sensor') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.sensor_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="lat">{{ trans('cruds.spaceUnit.fields.lat') }}</label>
                            <input class="form-control" type="text" name="lat" id="lat" value="{{ old('lat', '') }}">
                            @if($errors->has('lat'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('lat') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.lat_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="long">{{ trans('cruds.spaceUnit.fields.long') }}</label>
                            <input class="form-control" type="text" name="long" id="long" value="{{ old('long', '') }}">
                            @if($errors->has('long'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('long') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.spaceUnit.fields.long_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-danger" type="submit">
                                {{ trans('global.save') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection