@extends('layouts.frontend')
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card">
                <div class="card-header">
                    {{ trans('global.edit') }} {{ trans('cruds.tower.title_singular') }}
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route("frontend.towers.update", [$tower->id]) }}" enctype="multipart/form-data">
                        @method('PUT')
                        @csrf
                        <div class="form-group">
                            <label class="required" for="name">{{ trans('cruds.tower.fields.name') }}</label>
                            <input class="form-control" type="text" name="name" id="name" value="{{ old('name', $tower->name) }}" required>
                            @if($errors->has('name'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('name') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.tower.fields.name_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="lat">{{ trans('cruds.tower.fields.lat') }}</label>
                            <input class="form-control" type="text" name="lat" id="lat" value="{{ old('lat', $tower->lat) }}">
                            @if($errors->has('lat'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('lat') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.tower.fields.lat_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="long">{{ trans('cruds.tower.fields.long') }}</label>
                            <input class="form-control" type="text" name="long" id="long" value="{{ old('long', $tower->long) }}">
                            @if($errors->has('long'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('long') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.tower.fields.long_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="status">{{ trans('cruds.tower.fields.status') }}</label>
                            <input class="form-control" type="text" name="status" id="status" value="{{ old('status', $tower->status) }}">
                            @if($errors->has('status'))
                                <div class="invalid-feedback">
                                    {{ $errors->first('status') }}
                                </div>
                            @endif
                            <span class="help-block">{{ trans('cruds.tower.fields.status_helper') }}</span>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-danger" type="submit">
                                {{ trans('global.save') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection